package mole.entities.triggers 
{
	import mole.Main;
	import net.flashpunk.utils.Input;
	import net.flashpunk.utils.Key;
	/**
	 * Porte.
	 * @author Cédric Liaudet
	 */
	public class CDoor extends CTrigger
	{		
		/**
		 * Constructeur par défaut
		 * @param	_bOnce flag pour indiquer si on doit jouer le trigger qu'une seul fois
		 * @param	_Func Callback quand le trigger est activé
		 * @param	_aTypes Types accepter pour l'activation.
		 * @param	_iWith Largeur du trigger
		 * @param	_iHeight Hauteur du trigger.
		 */
		public function CDoor(_bOnce:Boolean, _Func:Function, _aTypes:Array, _iWith:int, _iHeight:int, _Name:String, _Destination:String)
		{
			super(_bOnce, OnActivated, _aTypes, _iWith, _iHeight);
			
			m_Name = _Name;
			m_DoorDestination = null;
			m_Destination = _Destination;
			type = "door";			
		}
		
		/**
		 * MAJ du trigger.
		 */
		override public function update():void
		{
			super.update();
			
			if (m_Entity && Input.pressed("active"))
			{
				Input.clear();
				m_Entity.x = m_DoorDestination.x;
				m_Entity.y = m_DoorDestination.y;
				m_Entity = null;
				
				Main.World.SnapToFloor(m_Entity);
			}
		}	
		
		/**
		 * Callback lors de l'activation.
		 */
		public function OnActivated():void
		{
			if (!m_DoorDestination && m_Destination)
			{
				var doors:Array = new Array;
				Main.World.getType("door", doors);
				
				for each(var door:CDoor in doors)
				{
					if (door.m_Name == m_Destination)
					{
						m_DoorDestination = door;
						break;
					}
				}
			}
		}
		
		private var m_Name:String;				///< Le nom de l'instance de la porte.
		private var m_Destination:String; 		///< Le nom de la destination.
		private var m_DoorDestination:CDoor;	///< La porte de destination.
	}
}